package ru.yandex.chemodan.app.notifier.utils;

import javax.annotation.PreDestroy;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.internal.Validate;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserType;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

/**
 * @author akirakozov
 */
public class BlackboxMultiplexed {
    private static final SetF<DataApiUserType> SUPPORTED_TYPES = Cf.set(DataApiUserType.PASSPORT, DataApiUserType.YT);

    private final Blackbox2 publicBlackbox;
    private final Blackbox2 ytBlackbox;

    public BlackboxMultiplexed(Blackbox2 publicBlackbox, Blackbox2 ytBlackbox) {
        this.publicBlackbox = publicBlackbox;
        this.ytBlackbox = ytBlackbox;
    }

    public Blackbox2 byUserId(DataApiUserId userId) {
        Validate.isTrue(SUPPORTED_TYPES.containsTs(userId.type),
                "Unsupported user id: " + userId);
        return userId.type == DataApiUserType.PASSPORT ? publicBlackbox : ytBlackbox;
    }

    public Blackbox2 getPublic() {
        return publicBlackbox;
    }

    public Blackbox2 getYandexTeam() {
        return ytBlackbox;
    }

    @PreDestroy
    public void destroy() {
        publicBlackbox.destroy();

        if (ytBlackbox != publicBlackbox) {
            ytBlackbox.destroy();
        }
    }

}
