package ru.yandex.chemodan.app.notifier.utils;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.metadata.NotifierLanguage;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxDbFields;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.net.LocalhostUtils;

/**
 * @author akirakozov
 */
public class UserLanguageHelper {
    private static final Logger logger = LoggerFactory.getLogger(UserLanguageHelper.class);

    private final BlackboxMultiplexed blackbox;

    public UserLanguageHelper(BlackboxMultiplexed blackbox) {
        this.blackbox = blackbox;
    }

    public NotifierLanguage getUserLanguageOrDefault(DataApiUserId uid) {
        return getUserLanguage(uid).getOrElse(NotifierLanguage.RUSSIAN);
    }

    public Option<NotifierLanguage> getUserLanguage(DataApiUserId uid) {
        return blackbox.byUserId(uid).query()
                .userInfo(LocalhostUtils.localAddress(), uid.toPassportUid(), Cf.list(BlackboxDbFields.LANG))
                .getDbFields()
                .getO(BlackboxDbFields.LANG)
                .flatMapO(NotifierLanguage.R::fromValueO);
    }

    public Option<String> getFirstNameO(DataApiUserId uid) {
        return blackbox.byUserId(uid).query()
                .userInfo(LocalhostUtils.localAddress(), uid.toPassportUid(), Cf.list(BlackboxDbFields.FIRSTNAME))
                .getDbFields()
                .getO(BlackboxDbFields.FIRSTNAME);
    }
}
