package ru.yandex.chemodan.app.notifier.worker;

import org.springframework.context.annotation.Bean;

import ru.yandex.chemodan.app.notifier.DiskNotificationManager;
import ru.yandex.chemodan.app.notifier.NotificationManager;
import ru.yandex.chemodan.app.notifier.promo.PromoActionManager;
import ru.yandex.chemodan.app.notifier.push.NotificationPushManager;
import ru.yandex.chemodan.app.notifier.worker.task.AddLentaNotificationBlockTask;
import ru.yandex.chemodan.app.notifier.worker.task.HolderForNotifierPushDeviceTask;
import ru.yandex.chemodan.app.notifier.worker.task.SendPromoPushTask;
import ru.yandex.chemodan.app.notifier.worker.task.SendPushTask;
import ru.yandex.chemodan.app.notifier.worker.task.UpdateNotificationBlockTask;
import ru.yandex.chemodan.notifier.AddLentaNotificationBlockerTask;
import ru.yandex.chemodan.util.BleedingEdge;
import ru.yandex.commune.bazinga.BazingaConfiguration;
import ru.yandex.commune.bazinga.BazingaConfigurator;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.tasks.BazingaHeartbeatTask;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author akirakozov
 */
public class NotificationTasksContextConfiguration {
    @Bean
    public CronTask bazingaHeartbeatTask(BazingaConfiguration bazingaConfiguration, ZkManager zkManager) {
        return new NotificationCronTaskWrapper(new BazingaHeartbeatTask(
                bazingaConfiguration,
                BazingaConfigurator.zkBazingaConfigurationStorage(bazingaConfiguration, zkManager)))
        {
            public TaskId id() {
                return new TaskId("bazingaHeartbeat.notifier");
            }
        };
    }

    @Bean
    public UpdateNotificationBlockTask updateNotificationBlockTask(NotificationManager notificationManager) {
        return new UpdateNotificationBlockTask(notificationManager);
    }

    @Bean
    public AddLentaNotificationBlockTask addLentaNotificationBlockTask(
            DiskNotificationManager diskNotificationManager,
            BleedingEdge bleedingEdge)
    {
        return new AddLentaNotificationBlockTask(diskNotificationManager, bleedingEdge);
    }

    @Bean
    public AddLentaNotificationBlockerTask addLentaNotificationBlockerTask() {
        return new AddLentaNotificationBlockerTask();
    }

    @Bean
    public HolderForNotifierPushDeviceTask holderForPushingNotificationToDeviceTask() {
        return new HolderForNotifierPushDeviceTask();
    }

    @Bean
    public SendPushTask sendPushTask(NotificationPushManager notificationPushManager) {
        return new SendPushTask(notificationPushManager);
    }

    @Bean
    public SendPromoPushTask sendPromoPushTask(PromoActionManager notificationPushManager) {
        return new SendPromoPushTask(notificationPushManager);
    }
}
