package ru.yandex.chemodan.app.notifier.worker;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.bazinga.BazingaWorkerTaskQueues;
import ru.yandex.chemodan.bazinga.ChemodanBazingaWorkerContextConfiguration;
import ru.yandex.chemodan.notifier.NotificationTaskQueueName;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTask;
import ru.yandex.commune.bazinga.pg.worker.PgBazingaWorkerConfiguration;
import ru.yandex.commune.bazinga.scheduler.TaskQueue;

/**
 * @author akirakozov
 */
@Configuration
@Import({
        ChemodanBazingaWorkerContextConfiguration.class,
        NotificationTasksContextConfiguration.class
})
public class NotificationWorkerContextConfiguration {

    @Bean
    public PgBazingaWorkerConfiguration pgBazingaWorkerConfiguration() {
        return new PgBazingaWorkerConfiguration(Cf.list(NotificationTaskQueueName.NOTIFIER_CRON));
    }

    @Bean
    public BazingaWorkerTaskQueues taskQueues() {
        return new BazingaWorkerTaskQueues(
                Option.of(NotificationTaskQueueName.NOTIFIER_CRON),
                Option.of(NotificationTaskQueueName.NOTIFIER_REGULAR),
                Option.empty(),
                Cf.list(new TaskQueue(CeleryOnetimeTask.BAZINGA_QUEUE_NAME, 1, 0)));
    }

}
