package ru.yandex.chemodan.app.notifier.worker.metadataprocessor;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaRecordType;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntity;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntityType;
import ru.yandex.chemodan.app.notifier.utils.BlackboxMultiplexed;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 */
public class ActionMetadataProcessorTest {

    @Mock
    private MpfsClient mpfsClient;
    private BlackboxMultiplexed blackbox;

    private ActionMetadataProcessor processor;

    @Before
    public void init() {
        MockitoAnnotations.initMocks(this);
        blackbox = MetadataProcessorTestUtils.createBlackboxMock();
        processor = new ActionMetadataProcessor(blackbox, mpfsClient, 1);
    }

    @Test
    public void processContentBlockField() throws Exception {
        MetadataEntity entity = createContentBlockMetadataField();
        processor.processField(entity, null, new MetadataProcessorContext());

        Assert.equals("login", entity.get("login"));
        Assert.equals("GO_TO_LENTA", entity.get("action"));
    }

    @Test
    public void process32GbField() throws Exception {
        MetadataEntity entity = create32GbMetadataField();
        processor.processField(entity, null, new MetadataProcessorContext());

        Assert.equals("GO_TO_TUNE_PAGE", entity.get("action"));
    }

    private MetadataEntity createContentBlockMetadataField() {
        return new MetadataEntity(MetadataEntityType.ACTION,
                Cf.toHashMap(Cf.map("action", ActionMetadataProcessor.GO_TO_LENTA,
                        "block-type", LentaRecordType.CONTENT_BLOCK.value(),
                        "uid", "123")));
    }

    private MetadataEntity create32GbMetadataField() {
        return new MetadataEntity(MetadataEntityType.ACTION,
                Cf.toHashMap(Cf.map("action", "GO_TO_TUNE_PAGE")));
    }
}
