package ru.yandex.chemodan.app.notifier.worker.metadataprocessor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.utils.BlackboxMultiplexed;
import ru.yandex.commune.util.RetryUtils;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxCorrectResponse;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxDbFields;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.net.LocalhostUtils;

/**
 * @author buberman
 */
public interface BlackboxRelatedMetadataProcessor extends MetadataProcessor {
    ListF<String> USER_INFO_FIELDS = Cf.list(BlackboxDbFields.FIRSTNAME, BlackboxDbFields.SEX);

    BlackboxMultiplexed getBlackbox();
    int retryCount();

    Logger logger = LoggerFactory.getLogger(BlackboxRelatedMetadataProcessor.class);

    /**
     * Obtains user info for given UID, cached in context.
     *
     * @param context Cache to be used across different metadata processors
     */
    default BlackboxCorrectResponse getUserInfo(String actorUid, MetadataProcessorContext context) {
        return context.getBlackboxResponse(actorUid,
                () -> {
                    DataApiUserId userId = DataApiUserId.parse(actorUid);
                    return RetryUtils.retryOrThrow(logger, retryCount(), () -> getBlackboxResponse(userId));
                });
    }

    default BlackboxCorrectResponse getBlackboxResponse(DataApiUserId userId) {
        return getBlackbox().byUserId(userId).query().userInfo(
                LocalhostUtils.localAddress(),
                Option.of(userId.toPassportUid()),
                Option.empty(),
                Option.empty(),
                USER_INFO_FIELDS,
                Cf.list(),
                Option.empty(),
                Option.empty(),
                true,
                Option.empty(),
                false,
                true);
    }
}
