package ru.yandex.chemodan.app.notifier.worker.metadataprocessor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntity;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntityType;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author buberman
 */
public class CommentMetadataProcessor implements MpfsRelatedMetadataProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CommentMetadataProcessor.class);

    private final MpfsClient mpfsClient;
    private final TextMetadataProcessor textMetadataProcessor;
    private final int retryCount;

    public CommentMetadataProcessor(
            MpfsClient mpfsClient, TextMetadataProcessor textMetadataProcessor, int retryCount)
    {
        this.mpfsClient = mpfsClient;
        this.textMetadataProcessor = textMetadataProcessor;
        this.retryCount = retryCount;
    }

    @Override
    public MpfsClient getMpfsClient() {
        return mpfsClient;
    }

    @Override
    public int retryCount() {
        return retryCount;
    }

    @Override
    public ListF<MetadataEntityType> getProcessingTypes() {
        return Cf.list(MetadataEntityType.COMMENT);
    }

    @Override
    public void processField(MetadataEntity field, NotificationRecord record, MetadataProcessorContext context) {
        textMetadataProcessor.processField(field, record, context);
        String ownerAndResourceId = DiskMetadataProcessorUtils.getResourceId(record);
        logger.debug("Getting resource info for resource "+ownerAndResourceId );

        try {
            MpfsFileInfo fileInfo = getMpfsFileInfo(ownerAndResourceId, context);

            field.put("resource_id", ownerAndResourceId);
            if (fileInfo.getMeta().getShortUrl().isPresent()) {
                field.put("link", fileInfo.getMeta().getShortUrl().get() + "?cid=" + field.get("id"));
            }
        } catch (RuntimeException e) {
            logger.warn(e, e);
        }
    }
}
