package ru.yandex.chemodan.app.notifier.worker.metadataprocessor;

import org.joda.time.DateTime;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntity;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntityType;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;

/**
 * @author buberman
 */
public class DateMetadataProcessor implements MetadataProcessor {
    @Override
    public ListF<MetadataEntityType> getProcessingTypes() {
        return Cf.list(MetadataEntityType.DATE);
    }

    @Override
    public void processField(MetadataEntity field, NotificationRecord record, MetadataProcessorContext context) {
        String msS = field.get("ms");
        Long msL = Long.parseLong(msS);
        field.put("text", new DateTime(msL).toString(MetadataProcessorManager.FORMAT_DATE));
    }
}
