package ru.yandex.chemodan.app.notifier.worker.metadataprocessor;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntity;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntityType;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;

/**
 * @author buberman
 */
public interface MetadataProcessor {
    /**
     * Returns list of types that are processed by this processor instance.
     */
    ListF<MetadataEntityType> getProcessingTypes();

    /**
     * Process appropriate field's metadata.
     * @param field
     * @param context   cache for network requests to avoid redundancy.
     */
    void processField(MetadataEntity field, NotificationRecord record, MetadataProcessorContext context);
}
