package ru.yandex.chemodan.app.notifier.worker.metadataprocessor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxCorrectResponse;
import ru.yandex.misc.geo.Coordinates;

/**
 * @author buberman
 */
public class MetadataProcessorContext {
    private Option<DataApiUserId> userId = Option.empty();
    private MapF<String, BlackboxCorrectResponse> blackboxResponse = Cf.hashMap();
    private MapF<String, MpfsFileInfo> mpfsFileInfo = Cf.hashMap();
    private MapF<String, MpfsFileInfo> publicInfo = Cf.hashMap();
    private MapF<PassportUid, Long> photosCount = Cf.hashMap();
    private Option<ListF<Coordinates>> photosCoordinates = Option.empty();

    public Option<DataApiUserId> getUserId() {
        return userId;
    }

    public void setUserId(DataApiUserId userId) {
        this.userId = Option.of(userId);
    }

    public BlackboxCorrectResponse getBlackboxResponse(String actorUid, Function0<BlackboxCorrectResponse> update) {
        return blackboxResponse.getOrElseUpdate(actorUid, update);
    }

    public MpfsFileInfo getMpfsFileInfo(String ownerAndResourceId, Function0<MpfsFileInfo> update) {
        return mpfsFileInfo.getOrElseUpdate(ownerAndResourceId, update);
    }

    public MpfsFileInfo getPublicInfo(String resourceId, Function0<MpfsFileInfo> update) {
        return publicInfo.getOrElseUpdate(resourceId, update);
    }

    public long getPhotosCount(PassportUid uid, Function0<Long> update) {
        return photosCount.getOrElseUpdate(uid, update);
    }

    public Option<ListF<Coordinates>> getPhotosCoordinates() {
        return photosCoordinates;
    }

    public void setPhotosCoordinates(ListF<Coordinates> photosCoordinates) {
        this.photosCoordinates = Option.of(photosCoordinates);
    }
}
