package ru.yandex.chemodan.app.notifier.worker.metadataprocessor;

import java.util.List;

import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntity;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntityType;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;
import ru.yandex.chemodan.app.notifier.worker.metadata.MetadataEntityNames;

/**
 * @author buberman
 */
public class MetadataProcessorManager {
    protected static final DateTimeFormatter FORMAT_DATE = DateTimeFormat.forPattern("dd.MM.yyyy");

    private final MapF<MetadataEntityType, MetadataProcessor> processors = Cf.hashMap();

    private void registerProcessor(MetadataProcessor processor) {
        List<MetadataEntityType> processingTypes = processor.getProcessingTypes();

        for (MetadataEntityType type : processingTypes) {
            processors.put(type, processor);
        }
    }

    public MetadataProcessorManager(List<MetadataProcessor> processors) {
        for (MetadataProcessor processor : processors) {
            registerProcessor(processor);
        }
    }

    private void addUserCountData(MetadataWrapper metadata, long count) {
        if (count > 0) {
            MetadataEntity countData = new MetadataEntity(MetadataEntityType.TEXT);
            countData.put("text", Long.toString(count));
            metadata.meta.put(MetadataEntityNames.COUNT, countData);
        }
    }

    public void processFields(MetadataWrapper metadata, NotificationRecord record) {
        processFields(metadata, record, new MetadataProcessorContext());
    }

    public void processFields(
            MetadataWrapper metadata,
            NotificationRecord record,
            MetadataProcessorContext context)
    {
        for (String fieldName : metadata.meta.keySet()) {
            MetadataEntity value = metadata.meta.getTs(fieldName);
            processors
                    .getO(value.getEntityType())
                    .forEach(p -> p.processField(value, record, context));
        }
    }

    public MetadataWrapper createNotificationMetadata(NotificationRecord lastNotification, Option<Long> usersCount) {
        MetadataWrapper metadata = lastNotification.metadata.clone();
        if (usersCount.isPresent()) {
            addUserCountData(metadata, usersCount.get());
        }

        processFields(metadata, lastNotification);
        return metadata;
    }

    public ListF<Tuple2<NotificationRecord, MetadataWrapper>> createNotificationMetadataForPush(
            ListF<NotificationRecord> notifications)
    {
        MetadataProcessorContext context = new MetadataProcessorContext();

        return notifications.map(notification ->  {
            MetadataWrapper metadata = notification.metadata.clone();
            processFields(metadata, notification, context);
            return new Tuple2(notification, metadata);
        });
    }

}
