package ru.yandex.chemodan.app.notifier.worker.metadataprocessor;

import java.util.List;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.utils.BlackboxMultiplexed;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.passport.blackbox2.BlackboxQueryable;
import ru.yandex.inside.passport.blackbox2.protocol.BlackboxMethod;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxCorrectResponse;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxDbFields;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxDisplayName;
import ru.yandex.misc.ip.IpAddress;

import static org.mockito.Matchers.any;
import static org.mockito.Matchers.anyBoolean;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

/**
 * @author buberman
 */
public class MetadataProcessorTestUtils {
    public static BlackboxMultiplexed createBlackboxMock() {
        return new BlackboxMultiplexed(
                createBlackbox2Mock("login", "Frist name", "Display name", "Public N."),
                createBlackbox2Mock("ya_team_user", "Ятима", "Ятима Юзеров", "Ятима Ю."));
    }

    private static Blackbox2 createBlackbox2Mock(
            String login, String firstName, String displayName, String publicName)
    {
        Blackbox2 blackbox2 = mock(Blackbox2.class);
        mockBlackboxRequest(blackbox2,
                getBlackboxResponse(login, firstName, Option.of(displayName), Option.of(publicName)));
        return blackbox2;
    }

    public static void mockBlackboxRequest(Blackbox2 blackbox2, BlackboxCorrectResponse userInfo) {
        BlackboxQueryable queryable = mock(BlackboxQueryable.class);
        when(blackbox2.query()).thenReturn(queryable);

        when(queryable.userInfo(any(IpAddress.class), any(PassportUid.class), any(List.class))).thenReturn(userInfo);
        when(queryable.userInfo(
                any(), any(), any(), any(), any(), any(), any(), any(),
                anyBoolean(), any(), anyBoolean(), anyBoolean())).thenReturn(userInfo);
    }

    public static BlackboxCorrectResponse getBlackboxResponse(String login,
            String firstName, Option<String> displayName, Option<String> publicName)
    {
        Option<BlackboxDisplayName> displaNameO = displayName.map(
                name -> new BlackboxDisplayName(name, Option.empty(), Option.empty(), Option.empty(), publicName));
        return new BlackboxCorrectResponse(
                    BlackboxMethod.USER_INFO, Option.empty(), Option.empty(), 200, Option.empty(), Option.empty(),
                    Option.of(login), Cf.map(BlackboxDbFields.FIRSTNAME, firstName), Cf.list(), Cf.list(),
                    Option.empty(), Cf.map(), Option.empty(), Option.empty(), Option.empty(), Option.empty(),
                    Option.of("regname"), displaNameO);
    }

}
