package ru.yandex.chemodan.app.notifier.worker.metadataprocessor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntity;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntityType;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.chemodan.app.notifier.notification.NotificationActor;
import ru.yandex.chemodan.app.notifier.worker.metadata.MetadataEntityNames;


/**
 * @author akirakozov
 */
public class MetadataProcessorUtils {

    public static void addActor(MetadataWrapper metadata, NotificationActor actor) {
        MetadataEntity actorEntity = actor.isUser() ?
                new MetadataEntity(MetadataEntityType.USER, Cf.map("uid", actor.getUid().toString())) :
                new MetadataEntity(new MetadataEntityType(actor.serialize()));
        metadata.meta.put(MetadataEntityNames.ACTOR, actorEntity);
    }

    private static MetadataWrapper createMobileLinksMetadata(MapF<String, String> linksMap) {
        MetadataWrapper metadata = MetadataWrapper.createEmpty();
        MetadataEntity linksEntity = new MetadataEntity(MetadataEntityType.LINK, linksMap);
        metadata.meta.put(MetadataEntityNames.MOBILE_LINK, linksEntity);
        return metadata;
    }

}
