package ru.yandex.chemodan.app.notifier.worker.metadataprocessor;

import java.util.List;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.lentaloader.cool.utils.BlockTitlesGenerator;
import ru.yandex.chemodan.app.lentaloader.cool.utils.GeoNamesSource;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchClient;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchClientContextConfiguration;
import ru.yandex.chemodan.app.notifier.inflector.InflectorConfiguration;
import ru.yandex.chemodan.app.notifier.locale.LocaleContextConfiguration;
import ru.yandex.chemodan.app.notifier.tanker.TankerManager;
import ru.yandex.chemodan.app.notifier.utils.BlackboxMultiplexed;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.geobase.HttpGeobase;
import ru.yandex.geobase.beans.GeobaseRegionTranslations;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.spring.ApplicationContextUtils;

/**
 * @author buberman
 */
@Configuration
@Import({InflectorConfiguration.class,
        LocaleContextConfiguration.class,
        DiskSearchClientContextConfiguration.class,
})
public class NotifierMetadataProcessorsConfiguration {

    @Bean
    public ActionMetadataProcessor actionMetadataProcessor(
            BlackboxMultiplexed blackbox,
            MpfsClient notifierMpfsClient,
            @Value("${notifier.retry.count}") int retryCount)
    {
        return new ActionMetadataProcessor(blackbox, notifierMpfsClient, retryCount);
    }

    @Bean
    public UserMetadataProcessor actorMetadataProcessor(
            BlackboxMultiplexed blackbox,
            @Value("${notifier.retry.count}") int retryCount)
    {
        return new UserMetadataProcessor(blackbox, retryCount);
    }

    @Bean
    public CommentMetadataProcessor commentMetadataProcessor(
            MpfsClient notifierMpfsClient,
            TextMetadataProcessor textMetadataProcessor,
            @Value("${notifier.retry.count}") int retryCount)
    {
        return new CommentMetadataProcessor(notifierMpfsClient, textMetadataProcessor, retryCount);
    }

    @Bean
    public ResourceMetadataProcessor resourceMetadataProcessor(
            MpfsClient notifierMpfsClient,
            @Value("${notifier.retry.count}") int retryCount)
    {
        return new ResourceMetadataProcessor(notifierMpfsClient, retryCount);
    }


    @Bean
    public TextMetadataProcessor textMetadataProcessor(
            @Value("${notifier.notification.text.max-length}") int maxLength,
            @Value("${notifier.notification.text.max-lines}") int maxLines)
    {
        return new TextMetadataProcessor(maxLength, maxLines);
    }

    @Bean
    public DateMetadataProcessor dateMetadataProcessor() {
        return new DateMetadataProcessor();
    }

    @Bean
    public TotalPhotosMetadataProcessor totalPhotosMetadataProcessor(DiskSearchClient diskSearchClient) {
        return new TotalPhotosMetadataProcessor(diskSearchClient);
    }

    @Bean
    public MetadataProcessorManager metadataProcessorManager(ApplicationContext context) {
        List<MetadataProcessor> processors =
                ApplicationContextUtils.beansOfType(context, MetadataProcessor.class);
        return new MetadataProcessorManager(processors);
    }

    @Bean
    public HttpGeobase httpGeobase() {
        return HttpGeobase.getInstance();
    }

    @Bean
    public BlockTitlesGenerator blockTitlesGenerator(HttpGeobase httpGeobase) {
        return new BlockTitlesGenerator(new GeoNamesSource() {
            @Override
            public String getGeoName(int regionId, Case translationCase, Language lang) {
                GeobaseRegionTranslations translations = httpGeobase.getTranslations(regionId, lang.value());
                switch (translationCase) {
                    case DATIVE: return translations.getDativeCase();
                    case ABLATIVE: return translations.getAblativeCase();
                    case GENITIVE: return translations.getGenitiveCase();
                    case LOCATIVE: return translations.getLocativeCase();
                    case ACCUSATIVE: return translations.getAccusativeCase();
                    case NOMINATIVE: return translations.getNominativeCase();
                    case DIRECTIONAL: return translations.getDirectionalCase();
                    case PREPOSITION: return translations.getPreposition();
                    case INSTRUMENTAL: return translations.getInstrumentalCase();
                    case PREPOSITIONAL: return translations.getPrepositionalCase();
                    default: throw new IllegalArgumentException("Unknown case " + translationCase);
                }
            }
        });
    }

    @Bean
    public DiskMetadataProcessorManager diskMetadataProcessorManager(
            MetadataProcessorManager metadataProcessorManager, TankerManager tankerManager, BlockTitlesGenerator blockTitlesGenerator)
    {
        return new DiskMetadataProcessorManager(metadataProcessorManager, tankerManager, blockTitlesGenerator);
    }
}
