package ru.yandex.chemodan.app.notifier.worker.metadataprocessor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchClient;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntity;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntityType;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author dbrylev
 */
public class TotalPhotosMetadataProcessor implements MetadataProcessor {

    private static final Logger logger = LoggerFactory.getLogger(TotalPhotosMetadataProcessor.class);

    private final DiskSearchClient searchClient;

    public TotalPhotosMetadataProcessor(DiskSearchClient searchClient) {
        this.searchClient = searchClient;
    }

    @Override
    public ListF<MetadataEntityType> getProcessingTypes() {
        return Cf.list(MetadataEntityType.TOTAL_PHOTOS);
    }

    @Override
    public void processField(MetadataEntity field, NotificationRecord record, MetadataProcessorContext context) {
        Option<PassportUid> uid = context.getUserId()
                .map(DataApiUserId::toPassportUidOrZero).filterMap(PassportUidOrZero::toPassportUidO);

        if (uid.isPresent()) {
            try {
                field.put("text", Long.toString(context.getPhotosCount(
                        uid.get(), () -> searchClient.findPhotosliceDocumentsCount(uid.get()))));

            } catch (RuntimeException e) {
                logger.warn("Failed to obtain total photos for user {}: {}", uid.get(), e);
            }

        } else {
            logger.warn("Incorrect user to get total photos for {}", context.getUserId().getOrNull());
        }
    }
}
