package ru.yandex.chemodan.app.notifier.worker.metadataprocessor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntity;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntityType;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;
import ru.yandex.chemodan.app.notifier.utils.BlackboxMultiplexed;
import ru.yandex.chemodan.util.blackbox.UserInfoUtils;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxCorrectResponse;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxDbFields;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxDisplayName;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author buberman
 */
public class UserMetadataProcessor implements BlackboxRelatedMetadataProcessor {
    private static final Logger logger = LoggerFactory.getLogger(UserMetadataProcessor.class);

    private final BlackboxMultiplexed blackbox;
    private final int retryCount;

    public UserMetadataProcessor(BlackboxMultiplexed blackbox, int retryCount) {
        this.blackbox = blackbox;
        this.retryCount = retryCount;
    }

    @Override
    public BlackboxMultiplexed getBlackbox() {
        return blackbox;
    }

    @Override
    public int retryCount() {
        return retryCount;
    }

    @Override
    public ListF<MetadataEntityType> getProcessingTypes() {
        return Cf.list(MetadataEntityType.USER);
    }

    @Override
    public void processField(MetadataEntity field, NotificationRecord record, MetadataProcessorContext context) {
        String actorUid = field.get("uid");
        logger.debug("Getting user info for user " + actorUid);
        try {
            BlackboxCorrectResponse userInfo = getUserInfo(actorUid, context);

            Option<String> name =
                    userInfo.getDisplayName().filterMap(BlackboxDisplayName::getPublicName)
                    .plus(userInfo.getDbFields().getO(BlackboxDbFields.FIRSTNAME))
                    .findNot(StringUtils::isBlank);
            name.forEach(s -> field.put("text", s));

            Option<String> gender = userInfo
                    .getDbFields().getO(BlackboxDbFields.SEX)
                    .flatMapO(UserInfoUtils::translateSexO);
            gender.forEach(s ->  field.put("gender", s));

            Option<String> login = userInfo.getLogin();
            login.forEach(s -> field.put("login", s));

            logger.debug("User info obtained successfully.");
        } catch (RuntimeException e) {
            logger.error("Exception while retrieving user data for user "+actorUid, e);
        }

    }
}
