package ru.yandex.chemodan.app.notifier.worker.metadataprocessor;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiYaTeamUserId;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.chemodan.app.notifier.notification.NotificationActor;
import ru.yandex.chemodan.app.notifier.utils.BlackboxMultiplexed;
import ru.yandex.chemodan.app.notifier.worker.metadata.MetadataEntityNames;
import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 */
public class UserMetadataProcessorTest {

    private UserMetadataProcessor userMetadataProcessor;
    private BlackboxMultiplexed blackbox;

    @Before
    public void init() {
        blackbox = MetadataProcessorTestUtils.createBlackboxMock();
        userMetadataProcessor = new UserMetadataProcessor(blackbox, 1);
    }

    @Test
    public void processFieldForPublicUser() throws Exception {
        MetadataWrapper metadata = MetadataWrapper.createEmpty();
        MetadataProcessorUtils.addActor(metadata, NotificationActor.consFromUid(1234));

        userMetadataProcessor.processField(
                metadata.getEntityFieldsO(MetadataEntityNames.ACTOR).get(), null, new MetadataProcessorContext());

        Assert.some("Public N.", metadata.getEntityField(MetadataEntityNames.ACTOR, "text"));
    }

    @Test
    public void processFieldForPublicUserWithoutDisplayName() throws Exception {
        MetadataWrapper metadata = MetadataWrapper.createEmpty();
        MetadataProcessorUtils.addActor(metadata, NotificationActor.consFromUid(1234));

        MetadataProcessorTestUtils.mockBlackboxRequest(
                blackbox.getPublic(),
                MetadataProcessorTestUtils.getBlackboxResponse("login", "Вася Пупкин", Option.empty(), Option.empty()));

        userMetadataProcessor.processField(
                metadata.getEntityFieldsO(MetadataEntityNames.ACTOR).get(), null, new MetadataProcessorContext());

        Assert.some("Вася Пупкин", metadata.getEntityField(MetadataEntityNames.ACTOR, "text"));
    }

    @Test
    public void processFieldForYaTeamUser() throws Exception {
        MetadataWrapper metadata = MetadataWrapper.createEmpty();
        MetadataProcessorUtils.addActor(
                metadata, NotificationActor.consFromUid(new DataApiYaTeamUserId("1120000000000000")));

        userMetadataProcessor.processField(
                metadata.getEntityFieldsO(MetadataEntityNames.ACTOR).get(), null, new MetadataProcessorContext());

        Assert.some("Ятима Ю.", metadata.getEntityField(MetadataEntityNames.ACTOR, "text"));
    }

}
