package ru.yandex.chemodan.app.notifier.worker.task;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.dataapi.utils.BleedingEdgeUtils;
import ru.yandex.chemodan.app.notifier.DiskNotificationManager;
import ru.yandex.chemodan.util.BleedingEdge;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class AddLentaNotificationBlockTask
        extends ru.yandex.chemodan.notifier.AddLentaNotificationBlockTask
{
    private static final Logger logger = LoggerFactory.getLogger(AddLentaNotificationBlockTask.class);

    private DiskNotificationManager notificationManager;
    private BleedingEdge bleedingEdge;

    public AddLentaNotificationBlockTask(
            DiskNotificationManager notificationManager, BleedingEdge bleedingEdge)
    {
        super();
        this.notificationManager = notificationManager;
        this.bleedingEdge = bleedingEdge;
    }

    @Override
    protected void doExecute(Parameters parameters, ExecutionContext context) {
        if (BleedingEdgeUtils.isOnBleedingEdge(bleedingEdge).test(parameters.activeUid.uid)) {
            if (parameters.sendImmediately.isSome(true)) {
                notificationManager.addLentaBlock(parameters.activeUid.uid, parameters.activeUid.blockId, Instant.now().minus(Duration.standardDays(1)));
            } else {
                notificationManager.addLentaBlock(parameters.activeUid.uid, parameters.activeUid.blockId);
            }
        } else {
            logger.debug("Notifications for user: {} are disabled now", parameters.activeUid.uid );
        }
    }

}
