package ru.yandex.chemodan.app.notifier.worker.task;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.notifier.NotificationTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class HolderForNotifierPushDeviceTask extends OnetimeTaskSupport<PushDeviceDelayTaskParams> {

    private static final Logger logger = LoggerFactory.getLogger(HolderForNotifierPushDeviceTask.class);

    protected HolderForNotifierPushDeviceTask(PushDeviceDelayTaskParams parameters) {
        super(parameters);
    }

    public HolderForNotifierPushDeviceTask() {
        super(PushDeviceDelayTaskParams.class);
    }

    public HolderForNotifierPushDeviceTask(DataApiUserId uid, String deviceId) {
        this(new PushDeviceDelayTaskParams(uid, deviceId));
    }

    @Override
    protected void execute(PushDeviceDelayTaskParams parameters, ExecutionContext context) throws Exception {
        logger.info("Release lock for new pushing notification {}", parameters);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardSeconds(5);
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Override
    public TaskQueueName queueName() {
        return NotificationTaskQueueName.NOTIFIER_REGULAR;
    }



}
