package ru.yandex.chemodan.app.notifier.worker.task;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.chemodan.app.notifier.promo.PromoActionManager;
import ru.yandex.chemodan.notifier.NotificationTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author vpronto
 */
public class SendPromoPushTask extends OnetimeTaskSupport<SendPromoPushTask.Parameters> {
    private PromoActionManager promoActionManager;

    public SendPromoPushTask(Parameters parameters) {
        super(parameters);
    }

    public SendPromoPushTask(PromoActionManager promoActionManager) {
        super(Parameters.class);
        this.promoActionManager = promoActionManager;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        promoActionManager.sendPromo(parameters.uid, parameters.platform, parameters.metadata);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(1);
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Override
    public TaskQueueName queueName() {
        return NotificationTaskQueueName.NOTIFIER_REGULAR;
    }

    @BenderBindAllFields
    public static class Parameters {
        public final DataApiUserId uid;
        public final Option<String> platform;
        public final Option<MetadataWrapper> metadata;

        public Parameters(DataApiUserId uid, Option<String> platform, Option<MetadataWrapper> metadata) {
            this.uid = uid;
            this.platform = platform;
            this.metadata = metadata;
        }
    }
}
