package ru.yandex.chemodan.app.notifier.worker.task;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.chemodan.app.notifier.notification.NotificationActor;
import ru.yandex.chemodan.app.notifier.notification.NotificationTemplate;
import ru.yandex.chemodan.app.notifier.push.NotificationPushInfo;
import ru.yandex.chemodan.app.notifier.settings.GlobalSubscriptionChannel;
import ru.yandex.chemodan.app.notifier.tanker.TankerMessageKey;
import ru.yandex.chemodan.util.JsonAssert;
import ru.yandex.commune.bazinga.BazingaBender;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class SendPushTaskTest {
    private static final String JSON = ("{"
                    + "'uid':'1','info':{"
                    + "'template':{'name':'','type':'','group':'','service':'','icon':'',"
                    + "'messageKey':{'keysetId':'1','key':'2'},"
                    + "'titleMessageKey':{'keysetId':'1','key':'2'},"
                    + "'shortMessageKey':{'keysetId':'1','key':'2'},"
                    + "'defaultMeta':{'meta':{}},'delay':0"
                    + "},"
                    + "'actor':'ya_disk','ctime':1536888383595},'metadata':{'meta':{}},"
                    + "'channels':['ios-bright']"
            + "}").replaceAll("'", "\"");

    @Test
    public void serialize() {
        byte[] actualJson = BazingaBender.mapper.serializeJson(consTaskParameters());
        JsonAssert.equalsLenient(JSON, new String(actualJson));
    }

    @Test
    public void parse() {
        Assert.equals(consTaskParameters(), BazingaBender.mapper.parseJson(SendPushTask.Parameters.class, JSON));
    }

    private static SendPushTask.Parameters consTaskParameters() {
        MetadataWrapper metadata = new MetadataWrapper(Cf.map());
        TankerMessageKey tankerKey = new TankerMessageKey("1", "2");
        NotificationTemplate template = new NotificationTemplate(
                "", "", "", "", "", tankerKey,tankerKey,tankerKey, metadata, Duration.ZERO, Option.empty()
        );
        return new SendPushTask.Parameters(
                new DataApiPassportUserId(1L),
                new NotificationPushInfo(template, NotificationActor.YA_DISK, new Instant(1536888383595L)),
                metadata,
                Option.of(Cf.set(GlobalSubscriptionChannel.IOS_BRIGHT)), Option.empty()
        );
    }
}
