package ru.yandex.chemodan.app.notifier.worker.task;

import lombok.RequiredArgsConstructor;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.NotificationManager;
import ru.yandex.chemodan.app.notifier.log.NotifierEvent;
import ru.yandex.chemodan.bazinga.YcridOnetimeTaskSupport;
import ru.yandex.chemodan.bazinga.YcridTaskParameters;
import ru.yandex.chemodan.http.YandexCloudRequestIdHolder;
import ru.yandex.chemodan.notifier.NotificationTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;


/**
 * @author akirakozov
 */
public class UpdateNotificationBlockTask extends YcridOnetimeTaskSupport<UpdateNotificationBlockTask.Parameters> {
    private NotificationManager notificationManager;

    public UpdateNotificationBlockTask(Parameters parameters) {
        super(parameters);
    }

    public UpdateNotificationBlockTask(DataApiUserId uid, String service, String type, String groupKey) {
        super(new Parameters(uid, service, type, groupKey, YandexCloudRequestIdHolder.getO()));
    }

    public UpdateNotificationBlockTask(NotificationManager notificationManager) {
        super(Parameters.class);
        this.notificationManager = notificationManager;
    }

    @Override
    protected void doExecute(Parameters parameters, ExecutionContext context) {
        NotifierEvent.performScheduledBlockUpdate(parameters.uid, parameters.groupKey, parameters.type).log();

        notificationManager.updateOrCreateNotificationBlock(
                parameters.uid, parameters.service, parameters.type, parameters.groupKey);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(1);
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Override
    public TaskQueueName queueName() {
        return NotificationTaskQueueName.NOTIFIER_REGULAR;
    }

    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return ActiveParameters.Converter.class;
    }

    public UpdateNotificationBlockTask instant() {
        return new UpdateNotificationBlockTask(getParametersTyped().instant());
    }

    @BenderBindAllFields
    public static class Parameters extends YcridTaskParameters {
        public final DataApiUserId uid;
        public final String service;
        public final String type;
        public final String groupKey;
        public final boolean instant;

        public Parameters(
                DataApiUserId uid, String service, String type, String groupKey,
                Option<String> ycrid, boolean instant)
        {
            super(ycrid);
            this.uid = uid;
            this.service = service;
            this.type = type;
            this.groupKey = groupKey;
            this.instant = instant;
        }

        public Parameters(DataApiUserId uid, String service, String type, String groupKey, Option<String> ycrid) {
            this(uid, service, type, groupKey, ycrid, false);
        }

        public Parameters instant() {
            return new Parameters(uid, service, type, groupKey, ycrid, true);
        }
    }

    @BenderBindAllFields
    @RequiredArgsConstructor
    public static class ActiveParameters {
        public final DataApiUserId uid;
        public final String service;
        public final String type;
        public final String groupKey;
        public final boolean instant;

        public static class Converter implements ActiveUniqueIdentifierConverter<Parameters, ActiveParameters> {
            @Override
            public Class<ActiveParameters> getActiveUniqueIdentifierClass() {
                return ActiveParameters.class;
            }

            @Override
            public ActiveParameters convert(Parameters parameters) {
                return new ActiveParameters(parameters.uid, parameters.service, parameters.type, parameters.groupKey,
                        parameters.instant);
            }
        }
    }
}
