package ru.yandex.chemodan.app.orchestrator;

/**
 * @author yashunsky
 */

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.orchestrator.actions.SessionsActions;
import ru.yandex.chemodan.app.orchestrator.manager.SessionsManager;
import ru.yandex.chemodan.boot.ChemodanActionAppConfigurator;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.chemodan.util.web.interceptors.ThreadLocalCacheInterceptor;
import ru.yandex.chemodan.web.JacksonContextConfiguration;
import ru.yandex.chemodan.web.JacksonMapResultSerializer;
import ru.yandex.chemodan.web.JacksonPojoResultSerializer;
import ru.yandex.chemodan.zk.registries.tvm.ZkTvm2ContextConfiguration;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.parameter.bind.JacksonParameterBinder;
import ru.yandex.commune.a3.action.result.AddCommonAttributesInterceptor;
import ru.yandex.commune.a3.action.result.ApplicationInfo;

@Configuration
@Import({
        A3JettyContextConfiguration.class,
        ZkTvm2ContextConfiguration.class,
        ChemodanCommonContextConfiguration.class,
        JacksonContextConfiguration.class,
})
public class OrchestratorApiActionsContextConfiguration {
    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(
                Tuple2List.fromPairs("/*", "")
        );
    }

    @Bean
    public ActionApp actionApp(ApplicationContext context, ApplicationInfo applicationInfo,
                               ObjectMapper objectMapper)
    {
        ChemodanActionAppConfigurator configurator = ChemodanActionAppConfigurator.cons(applicationInfo, context);

        configurator.getBuilder()
                .addInvocationInterceptors(Cf.list(
                        new AddCommonAttributesInterceptor(applicationInfo),
                        new ThreadLocalCacheInterceptor()))
                .addParameterBinders(Cf.list(new JacksonParameterBinder(objectMapper)))
                .addResultSerializers(Cf.list(
                        new JacksonPojoResultSerializer(objectMapper), new JacksonMapResultSerializer(objectMapper)
                ));

        return configurator.configure();
    }

    @Bean
    public SessionsActions sessionsActions(SessionsManager sessionsManager) {
        return new SessionsActions(sessionsManager);
    }
}
