package ru.yandex.chemodan.app.orchestrator;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.db.monica.JdbcMetricsSwitch;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;


public class OrchestratorApiMain extends AbstractOrchestratorMainSupport {

    private final String APP_NAME = "orchestrator-api";

    public static void main(String[] args) {
        JdbcMetricsSwitch.ENABLED = true;
        JdbcMetricsSwitch.COMMAND_METRICS_ENABLED = true;
        new OrchestratorApiMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("disk", APP_NAME + EnvironmentType.getActiveSecondary().map(env -> "-" + env).orElse(""));
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return super.applicationSpecificContextPath()
                .plus(Cf.list(OrchestratorApiContextConfiguration.class
        ));
    }
}
