package ru.yandex.chemodan.app.orchestrator.actions;

import lombok.AllArgsConstructor;

import ru.yandex.chemodan.app.orchestrator.dao.SessionFinishReason;
import ru.yandex.chemodan.app.orchestrator.exceptions.SessionNotFoundException;
import ru.yandex.chemodan.app.orchestrator.manager.SessionsManager;
import ru.yandex.chemodan.app.orchestrator.pojo.SessionPojo;
import ru.yandex.chemodan.app.orchestrator.pojo.SessionsListPojo;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author yashunsky
 */
@ActionContainer
@AllArgsConstructor
public class SessionsActions {
    private final SessionsManager sessionsManager;

    @Path(value = "/v1/session/{sessionId}", methods = HttpMethod.PUT)
    public SessionPojo createSession(
            @PathParam("sessionId") String sessionId,
            @RequestParam("groupId") String groupId)
    {
        return sessionsManager.createSession(sessionId, groupId);
    }

    @Path(value = "/v1/session/{sessionId}", methods = HttpMethod.GET)
    public SessionPojo getSession(
            @PathParam("sessionId") String sessionId)
    {
        return sessionsManager.getSession(sessionId).getOrThrow(() -> new SessionNotFoundException(sessionId));
    }

    @Path(value = "/v1/session/{sessionId}", methods = HttpMethod.POST)
    public void touchSession(
            @PathParam("sessionId") String sessionId)
    {
        if (!sessionsManager.touchSession(sessionId)) {
            throw new SessionNotFoundException(sessionId);
        }
    }

    @Path(value = "/v1/session/{sessionId}", methods = HttpMethod.DELETE)
    public void deleteSession(
            @PathParam("sessionId") String sessionId)
    {
        sessionsManager.finishSession(sessionId, SessionFinishReason.FINISH_SIGNAL);
    }

    @Path(value = "/v1/session", methods = HttpMethod.GET)
    public SessionsListPojo listSession(
            @RequestParam("offset") int offset,
            @RequestParam("limit") int limit)
    {
        return sessionsManager.getAllSessions(offset, limit);
    }
}
