package ru.yandex.chemodan.app.orchestrator;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.orchestrator.cloud.ControlAgentClient;
import ru.yandex.chemodan.app.orchestrator.dao.ContainersDao;
import ru.yandex.chemodan.app.orchestrator.dao.SessionsDao;
import ru.yandex.chemodan.app.orchestrator.manager.OrchestratorControl;
import ru.yandex.chemodan.app.orchestrator.manager.OrchestratorControlRegistry;
import ru.yandex.chemodan.app.orchestrator.manager.SessionsManager;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author yashunsky
 */
@Configuration
@Import({
        OrchestratorJdbcContextConfiguration.class,
        OrchestratorDataSourceContextConfiguration.class
})
public class OrchestratorCoreContextConfiguration {
    @Bean
    public OrchestratorControl orchestratorControl(OrchestratorControlRegistry orchestratorControlRegistry) {
        return new OrchestratorControl(orchestratorControlRegistry);
    }

    @Bean
    public SessionsManager sessionManager(OrchestratorControl orchestratorControl,
                                          ControlAgentClient controlAgentClient,
                                          SessionsDao sessionsDao,
                                          ContainersDao containersDao)
    {
        return new SessionsManager(orchestratorControl, controlAgentClient, sessionsDao, containersDao);
    }

    @Bean
    @OverridableValuePrefix("orchestrator_control_agent")
    public HttpClientConfigurator controlAgentHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public ControlAgentClient controlAgentClient(OrchestratorControl orchestratorControl,
                                                 @Value("${node-state-field}") String nodeStateField) {
        return new ControlAgentClient(controlAgentHttpClientConfigurator().createBuilder().build(), orchestratorControl,
                nodeStateField);
    }

    @Bean
    public OrchestratorControlRegistry orchestratorControlRegistry(@Qualifier("zkRoot") ZkPath zkRoot, ZkManager zkManager) {
        OrchestratorControlRegistry registry = new OrchestratorControlRegistry(zkRoot.child("orchestrator-control"));
        zkManager.addClient(registry);
        return registry;
    }
}
