package ru.yandex.chemodan.app.orchestrator;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.misc.db.embedded.ConditionalOnMissingEmbeddedDb;

/**
 * @author yashunsky
 */
@Configuration
@ConditionalOnMissingEmbeddedDb
public class OrchestratorDataSourceContextConfiguration {
    @Bean
    @OverridableValuePrefix("orchestrator")
    public DataSourceProperties orchestratorDataSourceProperties() {
        return new DataSourceProperties();
    }
}
