package ru.yandex.chemodan.app.orchestrator;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.orchestrator.dao.ContainersDao;
import ru.yandex.chemodan.app.orchestrator.dao.SessionsDao;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfigurator;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfiguratorContextConfiguration;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author yashunsky
 */
@Configuration
@Import({
        JdbcDatabaseConfiguratorContextConfiguration.class,
})
public class OrchestratorJdbcContextConfiguration {

    @Autowired
    private JdbcDatabaseConfiguratorContextConfiguration dbConfiguratorConfig;


    @Bean
    public JdbcDatabaseConfigurator orchestratorDbConfigurator(DataSourceProperties orchestratorDataSourceProperties) {
        return dbConfiguratorConfig.consJdbcConfigurator(orchestratorDataSourceProperties);
    }

    @Bean
    public DataSource orchestratorDataSource(JdbcDatabaseConfigurator orchestratorDbConfigurator) {
        return orchestratorDbConfigurator.configureDataSource();
    }

    @Bean
    public JdbcTemplate3 orchestratorJdbcTemplate(JdbcDatabaseConfigurator orchestratorDbConfigurator,
                                                  DataSource orchestratorDataSource)
    {
        return orchestratorDbConfigurator.consTemplate(orchestratorDataSource);
    }

    @Bean
    public SessionsDao sessionsDao(JdbcTemplate3 orchestratorJdbcTemplate) {
        return new SessionsDao(orchestratorJdbcTemplate);
    }

    @Bean
    public ContainersDao containersDao(JdbcTemplate3 orchestratorJdbcTemplate) {
        return new ContainersDao(orchestratorJdbcTemplate);
    }
}
