<?xml version="1.0"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:z="urn:zscript-functions"
    version="2.0" xmlns:xls="http://www.w3.org/1999/XSL/Transform"
    exclude-result-prefixes="#all"
>

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/locations/location.js"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div class="container">
            <table class="table table-condensed table-bordered">
                <tr>
                    <th>Location</th>
                    <th>All</th>
                    <th>Available</th>
                    <th>Deactivated</th>
                    <th>Lost</th>
                </tr>

                <xsl:for-each select="locations">
                    <xls:variable name="key" select="key"/>
                    <xls:variable name="value" select="value"/>
                    <xsl:variable name="closed-location" select="../closed-location"/>


                    <xsl:choose>
                        <xsl:when test="$key = $closed-location">
                            <tr class="bg-warning">
                                <td>
                                    <xsl:value-of select="$key"/>
                                    [closed]
                                </td>
                                <td>
                                    <xsl:value-of select="$value/all"/>
                                </td>
                                <td>
                                    <xsl:value-of select="$value/available"/>
                                </td>
                                <td>
                                    <xsl:value-of select="$value/deactivated"/>
                                </td>
                                <td>
                                    <xsl:value-of select="$value/lost"/>
                                </td>
                            </tr>
                        </xsl:when>
                        <xsl:otherwise>
                            <tr>
                                <td>
                                    <xsl:value-of select="$key"/>
                                </td>
                                <td>
                                    <xsl:value-of select="$value/all"/>
                                </td>
                                <td>
                                    <xsl:value-of select="$value/available"/>
                                </td>
                                <td>
                                    <xsl:value-of select="$value/deactivated"/>
                                </td>
                                <td>
                                    <xsl:value-of select="$value/lost"/>
                                </td>
                            </tr>
                        </xsl:otherwise>
                    </xsl:choose>

                </xsl:for-each>
            </table>

            <a class="btn btn-lg btn-danger" data-toggle="modal" data-target="#closeDcModal">Закрыть ДЦ</a>
            <xsl:if test="closed-location">
                <button id="open-location-button" class="btn btn-lg btn-primary" type="button" style="margin-left: 50px">
                    Открыть
                    <span id="location-to-open">
                        <xsl:value-of select="closed-location"/>
                    </span>
                </button>
            </xsl:if>

            <div class="modal fade" id="closeDcModal" tabindex="-1" role="dialog" aria-labelledby="closeDC"
                 aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h3>Точно хотите закрыть ДЦ?</h3>
                        </div>
                        <div class="modal-body">
                            <div class="form-horizontal">
                                <label>Выберите ДЦ</label>

                                <div class="btn-group btn-group-toggle btn-group-justified" data-toggle="buttons">
                                    <xsl:for-each select="locations/key">
                                        <label class="btn btn-default input-location-button">
                                            <input type="radio" name="location" value="{.}"/>
                                            <xsl:value-of select="."/>
                                        </label>
                                    </xsl:for-each>
                                </div>

                                <h1/>
                                <button id="close-location-button" class="btn btn-danger" type="button">Закрыть</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </xsl:template>

</xsl:stylesheet>
