package ru.yandex.chemodan.app.orchestrator.admin;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.orchestrator.dao.ContainersDao;
import ru.yandex.chemodan.app.orchestrator.manager.OrchestratorControl;
import ru.yandex.chemodan.app.orchestrator.manager.OrchestratorControlRegistry;
import ru.yandex.commune.admin.web.AdminApp;

/**
 * @author friendlyevil
 */
@Configuration
public class LocationAdminPageContextConfiguration {

    @Autowired
    private AdminApp adminApp;

    @Bean
    public LocationAdminPage locationAdminPage(OrchestratorControl orchestratorControl, ContainersDao containersDao,
                                               OrchestratorControlRegistry orchestratorControlRegistry) {
        LocationAdminPage page = new LocationAdminPage(orchestratorControl, containersDao, orchestratorControlRegistry);
        adminApp.registerAdminPage("Locations", page);
        return page;
    }
}
