package ru.yandex.chemodan.app.orchestrator.dao;

import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.ip.HostPort;
import ru.yandex.misc.lang.Check;

/**
 * @author yashunsky
 */
@Data
public class Container {
    private final String id;
    private final HostPort pod;
    private final String location;
    private final Option<String> groupId;
    private final ContainerDbState state;
    private final Instant createdDt;
    private final Instant modifiedDt;
    private final int sessionsCount;

    public ContainerLogicState getLogicState() {
        switch (state) {
            case AVAILABLE:
                if (groupId.isPresent()) {
                    if (sessionsCount > 0) {
                        return ContainerLogicState.ACTIVE;
                    } else {
                        return ContainerLogicState.DIRTY;
                    }
                } else {
                    Check.equals(0, sessionsCount);
                    return ContainerLogicState.READY;
                }
            case DEACTIVATED:
                return ContainerLogicState.DEACTIVATE;
            case LOST:
                return ContainerLogicState.LOST;
            default:
                throw new IllegalStateException("State " + state + " not supported");
        }
    }

    public Container withSessionsCount(int realSessionsCount) {
        return new Container(id, pod, location, groupId, state, createdDt, modifiedDt, realSessionsCount);
    }
}
