package ru.yandex.chemodan.app.orchestrator.dao;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author yashunsky
 */
public enum ContainerDbState implements StringEnum {
    AVAILABLE,
    DEACTIVATED,
    LOST;

    private final String value;

    ContainerDbState() {
        this.value = name().toLowerCase();
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<ContainerDbState> R = StringEnumResolver.r(ContainerDbState.class);
}
