package ru.yandex.chemodan.app.orchestrator.dao;

import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;

/**
 * @author yashunsky
 */
@Data
public class Session {
    private final String id;
    private final Option<String> containerId;
    private final Option<FinishReason> finishReason;
    private final Option<Instant> finishDt;
    private final Instant createdDt;
    private final Instant modifiedDt;
    private final Instant expirationDt;

    public boolean isActive() {
        return containerId.isPresent() && !(finishReason.isPresent() || finishDt.isPresent());
    }

    public Session withExpirationDt(Instant expirationDt) {
        return new Session(id, containerId, finishReason, finishDt, createdDt, modifiedDt, expirationDt);
    }
}
