package ru.yandex.chemodan.app.orchestrator.manager;

import lombok.Value;
import org.springframework.beans.factory.annotation.Qualifier;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.commune.bazinga.BazingaBender;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkPathEscaping;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.env.EnvironmentType;

/**
 * @author friendlyevil
 */
public class OrchestratorControlRegistry extends ZkRegistry<String, OrchestratorControlRegistry.ControlPojo> {
    public static final String ID = EnvironmentType.getActiveSecondary().getOrElse("location");

    public OrchestratorControlRegistry(@Qualifier("zkRoot") ZkPath zkPath) {
        super(zkPath, Bender.cons(ControlPojo.class, BazingaBender.getConfiguration()),
                o -> ID, Function.identityF(), ZkPathEscaping.asIs);
    }

    public ControlPojo get() {
        return getO(ID).orElse(new ControlPojo(Option.empty()));
    }

    @BenderBindAllFields
    @Value
    public static class ControlPojo {
        Option<String> closedDC;
    }
}
