package ru.yandex.chemodan.app.orchestrator.pojo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.orchestrator.dao.Container;
import ru.yandex.chemodan.app.orchestrator.dao.Session;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.ip.HostPort;

/**
 * @author yashunsky
 */
@AllArgsConstructor
@Data
public class SessionPojo implements JacksonPojo {
    @JsonProperty("session_id")
    private final String sessionId;
    private final HostPort container;
    @JsonProperty("group_id")
    private final String groupId;
    @JsonProperty("expiration_dt")
    private final Instant expirationDt;

    @JsonProperty("container")
    private String getSerializedContainer() {
        return container.toSerializedString();
    }

    public SessionPojo(Session session, Container container) {
        this.sessionId = session.getId();
        this.container = container.getPod();
        this.groupId = container.getGroupId().getOrThrow("Can not create session pojo for group-free container");
        this.expirationDt = session.getExpirationDt();
    }
}
