package ru.yandex.chemodan.app.orchestrator.unistat;

import ru.yandex.misc.monica.annotation.GroupByDefault;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.annotation.MonicaStaticRegistry;
import ru.yandex.misc.monica.core.blocks.MeterMap;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;

/**
 * @author yashunsky
 */
public class EventsMetrics {
    @MonicaMetric
    @GroupByDefault
    public static final MeterMap notActiveSessions = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    public static final MeterMap sessionsLimitAchieved = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    public static final MeterMap finishedSessions = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    public static final MeterMap createdSessions = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    public static final MeterMap touchedSessions = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    public static final MeterMap deletedSessions = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    public static final MeterMap lostUsedContainers = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    public static final MeterMap lostUnusedContainers = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    public static final MeterMap noAvailableContainers = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    public static final MeterMap containersLinkedToGroup = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    public static final MeterMap containersReused = new MeterMap();

    static {
        MonicaStaticRegistry.register(
                EventsMetrics.class,
                new MetricGroupName(
                        "orchestrator-events",
                        new MetricName("orchestrator", "events"),
                        "Orchestrator events metrics"
                )
        );
    }

}
