package ru.yandex.chemodan.app.orchestrator;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.orchestrator.manager.FromCloudActualizationManager;
import ru.yandex.chemodan.app.orchestrator.manager.SessionsManager;
import ru.yandex.chemodan.app.orchestrator.manager.ToCloudActualizationManager;
import ru.yandex.chemodan.app.orchestrator.tasks.OrchestratorQueueName;
import ru.yandex.chemodan.app.orchestrator.tasks.cron.AddContainersCronTask;
import ru.yandex.chemodan.app.orchestrator.tasks.cron.DeleteSessionsCronTask;
import ru.yandex.chemodan.app.orchestrator.tasks.cron.FinishSessionsCronTask;
import ru.yandex.chemodan.app.orchestrator.tasks.cron.RemoveContainersCronTask;
import ru.yandex.chemodan.app.orchestrator.tasks.onetime.ActivateContainerTask;
import ru.yandex.chemodan.app.orchestrator.tasks.onetime.DeactivateContainerTask;
import ru.yandex.chemodan.bazinga.BazingaWorkerTaskQueues;
import ru.yandex.chemodan.bazinga.ChemodanBazingaWorkerContextConfiguration;
import ru.yandex.commune.bazinga.pg.worker.PgBazingaWorkerConfiguration;
import ru.yandex.commune.bazinga.scheduler.TaskQueue;

/**
 * @author yashunsky
 */
@Configuration
@Import({
        ChemodanBazingaWorkerContextConfiguration.class,
})
public class OrchestratorWorkerBazingaContextConfiguration {
    @Bean
    public PgBazingaWorkerConfiguration pgBazingaWorkerConfiguration() {
        return new PgBazingaWorkerConfiguration(Cf.list(OrchestratorQueueName.CRON));
    }

    @Bean
    public BazingaWorkerTaskQueues taskQueues(
            @Value("${orchestrator.activation.tasks.count}") int activationThreadCount,
            @Value("${orchestrator.activation.tasks.queue}") int activationQueueCount,
            @Value("${orchestrator.deactivation.tasks.count}") int deactivationThreadCount,
            @Value("${orchestrator.deactivation.tasks.queue}") int deactivationQueueCount)
    {
        TaskQueue activationQueue = new TaskQueue(
                OrchestratorQueueName.ACTIVATION, activationThreadCount, activationQueueCount);
        TaskQueue deactivationQueue = new TaskQueue(
                OrchestratorQueueName.DEACTIVATION, deactivationThreadCount, deactivationQueueCount);

        return new BazingaWorkerTaskQueues(
                OrchestratorQueueName.CRON, OrchestratorQueueName.REGULAR, OrchestratorQueueName.CPU_INTENSIVE,
                Cf.list(activationQueue, deactivationQueue));
    }

    @Bean
    public ActivateContainerTask activateContainerTask(FromCloudActualizationManager actualizationManager) {
        return new ActivateContainerTask(actualizationManager);
    }

    @Bean
    public AddContainersCronTask addContainersFromCloudCronTask(FromCloudActualizationManager actualizationManager) {
        return new AddContainersCronTask(actualizationManager);
    }

    @Bean
    public DeactivateContainerTask deactivateContainerTask(ToCloudActualizationManager actualizationManager) {
        return new DeactivateContainerTask(actualizationManager);
    }

    @Bean
    public RemoveContainersCronTask removeContainersCronTask(ToCloudActualizationManager actualizationManager) {
        return new RemoveContainersCronTask(actualizationManager);
    }

    @Bean
    public FinishSessionsCronTask finishSessionsCronTask(SessionsManager sessionsManager) {
        return new FinishSessionsCronTask(sessionsManager);
    }

    @Bean
    public DeleteSessionsCronTask deleteSessionsCronTask(SessionsManager sessionsManager) {
        return new DeleteSessionsCronTask(sessionsManager);
    }
}
