package ru.yandex.chemodan.app.orchestrator;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.orchestrator.admin.LocationAdminPageContextConfiguration;
import ru.yandex.chemodan.app.orchestrator.cloud.ControlAgentClient;
import ru.yandex.chemodan.app.orchestrator.cloud.DiscoveryClient;
import ru.yandex.chemodan.app.orchestrator.dao.ContainersDao;
import ru.yandex.chemodan.app.orchestrator.dao.SessionsDao;
import ru.yandex.chemodan.app.orchestrator.manager.FromCloudActualizationManager;
import ru.yandex.chemodan.app.orchestrator.manager.OrchestratorControl;
import ru.yandex.chemodan.app.orchestrator.manager.SessionsManager;
import ru.yandex.chemodan.app.orchestrator.manager.StateManager;
import ru.yandex.chemodan.app.orchestrator.manager.ToCloudActualizationManager;
import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.commune.bazinga.BazingaTaskManager;

/**
 * @author yashunsky
 */
@Configuration
@Import({
        OrchestratorCoreContextConfiguration.class,
        OrchestratorWorkerBazingaContextConfiguration.class,
        LocationAdminPageContextConfiguration.class,
})
public class OrchestratorWorkerContextConfiguration {

    @Bean
    public DiscoveryClient discoveryClient(OrchestratorControl control,
                                           @Value("${orchestrator.yp.client-name}") String clientName,
                                           @Value("${orchestrator.yp.service-id-prefix}") String serviceIdPrefix,
                                           @Value("${orchestrator.yp.response-timeout}") Duration ypResponseTimeout)
    {
        return new DiscoveryClient(control, clientName, serviceIdPrefix, ypResponseTimeout);
    }

    @Bean
    public FromCloudActualizationManager fromCloudActualizationManager(ContainersDao containersDao,
                                                                       ControlAgentClient controlAgentClient,
                                                                       OrchestratorControl control,
                                                                       BazingaTaskManager bazingaTaskManager,
                                                                       DiscoveryClient discoveryClient,
                                                                       LocationResolver locationResolver,
                                                                       @Value("${orchestrator.actualization-threads}") int actualizationThreads)
    {
        return new FromCloudActualizationManager(
                containersDao, controlAgentClient, control, bazingaTaskManager, discoveryClient, locationResolver,
                actualizationThreads);
    }

    @Bean
    public ToCloudActualizationManager toCloudActualizationManager(ContainersDao containersDao,
                                                                   ControlAgentClient controlAgentClient,
                                                                   OrchestratorControl control,
                                                                   BazingaTaskManager bazingaTaskManager,
                                                                   SessionsManager sessionsManager,
                                                                   @Value("${orchestrator.actualization-threads}") int actualizationThreads)
    {
        return new ToCloudActualizationManager(
                containersDao, controlAgentClient, control, bazingaTaskManager, sessionsManager, actualizationThreads);
    }

    @Bean
    public StateManager stateManager(SessionsDao sessionsDao, ContainersDao containersDao,
                                     OrchestratorControl control)
    {
        return new StateManager(sessionsDao, containersDao, control);
    }
}
