package ru.yandex.chemodan.app.orchestrator.manager;

import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.orchestrator.exceptions.ActualizationFailureException;

/**
 * @author friendlyevil
 */
@Getter
@NoArgsConstructor
public class ActualisationStatistic<T> {
    int gettingSublistFailed = 0;
    int actualizeSubItemFailed = 0;
    ListF<ActualisationFailure<T>> failures = Cf.arrayList();

    public void addGettingSublistFailed(ActualisationFailure<T> failure) {
        gettingSublistFailed++;
        failures.add(failure);
    }

    public void addActualizeSubItemFailed(ActualisationFailure<T> failure) {
        actualizeSubItemFailed++;
        failures.add(failure);
    }

    public void add(ActualisationStatistic<T> statistic) {
        gettingSublistFailed += statistic.gettingSublistFailed;
        actualizeSubItemFailed += statistic.actualizeSubItemFailed;
        failures.addAll(statistic.getFailures());
    }

    public boolean hasFailures() {
        return gettingSublistFailed != 0 || actualizeSubItemFailed != 0;
    }

    public void throwIfHasFailures() {
        if (hasFailures()) {
            String message = Cf.x(failures).map(ActualisationFailure::getItem).mkString("\n");
            throw  new ActualizationFailureException(message);
        }
    }

    public static <T> ActualisationStatistic<T> of(ListF<ActualisationStatistic<T>> statistics) {
        ActualisationStatistic<T> result = new ActualisationStatistic<>();
        for (ActualisationStatistic<T> statistic : statistics) {
            result.add(statistic);
        }

        return result;
    }
}
