package ru.yandex.chemodan.app.orchestrator.tasks.cron;

import lombok.AllArgsConstructor;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.orchestrator.manager.ActualisationStatistic;
import ru.yandex.chemodan.app.orchestrator.manager.FromCloudActualizationManager;
import ru.yandex.chemodan.app.orchestrator.tasks.OrchestratorQueueName;
import ru.yandex.chemodan.bazinga.TaskIdUtils;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultToString;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author yashunsky
 */
@AllArgsConstructor
public class AddContainersCronTask extends CronTask {
    private static final Logger logger = LoggerFactory.getLogger(AddContainersCronTask.class);

    private final FromCloudActualizationManager actualizationManager;

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(Duration.standardMinutes(5));
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        ActualisationStatistic<String> statistic = actualizationManager.actualize();
        executionContext.setExecutionInfo(new ActualizeContainerStat(statistic));

        logger.info(
                "Statistic actualization cron:" +
                " subItemFailed " + statistic.getActualizeSubItemFailed() +
                " gettingSublistFailed " + statistic.getGettingSublistFailed()
        );
        statistic.throwIfHasFailures();
    }

    @Override
    public TaskQueueName queueName() {
        return OrchestratorQueueName.CRON;
    }

    @Override
    public TaskId id() {
        return TaskIdUtils.withSecondaryEnv(super.id());
    }

    @BenderBindAllFields
    private static class ActualizeContainerStat extends DefaultToString {
        private int actualizeDcFails;
        private int actualizePodFails;

        public ActualizeContainerStat(ActualisationStatistic<?> stat) {
            this.actualizeDcFails = stat.getGettingSublistFailed();
            this.actualizePodFails = stat.getActualizeSubItemFailed();
        }
    }
}
