package ru.yandex.chemodan.app.orchestrator.tasks.cron;

import lombok.AllArgsConstructor;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.orchestrator.manager.SessionsManager;
import ru.yandex.chemodan.app.orchestrator.tasks.OrchestratorQueueName;
import ru.yandex.chemodan.bazinga.TaskIdUtils;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;

/**
 * @author yashunsky
 */
@AllArgsConstructor
public class FinishSessionsCronTask extends CronTask {
    private final SessionsManager sessionsManager;

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(Duration.standardMinutes(5));
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        sessionsManager.finishExpiredSessions();
    }

    @Override
    public TaskQueueName queueName() {
        return OrchestratorQueueName.CRON;
    }

    @Override
    public TaskId id() {
        return TaskIdUtils.withSecondaryEnv(super.id());
    }
}
