package ru.yandex.chemodan.app.orchestrator.tasks.onetime;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.orchestrator.manager.FromCloudActualizationManager;
import ru.yandex.chemodan.app.orchestrator.tasks.OrchestratorQueueName;
import ru.yandex.chemodan.bazinga.TaskIdUtils;
import ru.yandex.commune.bazinga.BazingaStopExecuteException;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.ip.HostPort;

/**
 * @author yashunsky
 */
public class ActivateContainerTask extends OnetimeTaskSupport<ActivateContainerTask.Parameters> {
    private final FromCloudActualizationManager actualizationManager;

    public ActivateContainerTask(String location, String containerId, HostPort hostport) {
        super(new Parameters(containerId, location, hostport.getHost().toString(), hostport.getPort()));
        this.actualizationManager = null;
    }

    public ActivateContainerTask(FromCloudActualizationManager actualizationManager) {
        super(Parameters.class);
        this.actualizationManager = actualizationManager;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        String containerId = parameters.containerId;
        String host = parameters.host;

        if (actualizationManager.find(containerId).isPresent()) {
            return;
        }

        if (actualizationManager.awaitStarted(host, containerId)) {
            actualizationManager.createNewContainer(
                    containerId, new HostPort(host, parameters.port), parameters.location);
        } else {
            actualizationManager.abortActivation(host, containerId);
            throw new BazingaStopExecuteException("Aborted container " + containerId + " at " + host + " activation");
        }
    }

    @Override
    public TaskId id() {
        return TaskIdUtils.withSecondaryEnv(super.id());
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(10);
    }

    @Override
    public TaskQueueName queueName() {
        return OrchestratorQueueName.ACTIVATION;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final String containerId;
        private final String location;
        private final String host;
        private final int port;
    }
}
