package ru.yandex.chemodan.app.orchestrator.unistat;

import ru.yandex.misc.monica.annotation.GroupByDefault;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.annotation.MonicaStaticRegistry;
import ru.yandex.misc.monica.core.blocks.ValueMap;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;

/**
 * @author yashunsky
 */
public class StateMetrics {
    @MonicaMetric()
    @GroupByDefault
    public final static ValueMap<Integer> sessionsCount = new ValueMap<>(Integer.class);

    @MonicaMetric()
    @GroupByDefault
    public final static ValueMap<Integer> containersByState = new ValueMap<>(Integer.class);

    @MonicaMetric()
    @GroupByDefault
    public final static ValueMap<Integer> sessionsByGroup = new ValueMap<>(Integer.class);

    @MonicaMetric()
    @GroupByDefault
    public final static ValueMap<Integer> actualizationDuration = new ValueMap<>(Integer.class);

    static {
        MonicaStaticRegistry.register(
                StateMetrics.class,
                new MetricGroupName(
                        "orchestrator-state",
                        new MetricName("orchestrator", "state"),
                        "Orchestrator state metrics"
                )
        );
    }
}
