package ru.yandex.chemodan.balanceclient;

import java.net.URL;
import java.util.TimeZone;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import org.apache.commons.httpclient.ProxyHost;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@AllArgsConstructor
@Builder(toBuilder = true)
public class BalanceXmlRpcClientConfig extends DefaultObject {
    @Value("${balance.xmlrpc.requestsLoggerName}")
    private String loggerName;
    @Value("${balance.xmlrpc.url}")
    private URL serverUrl;
    @Value("${balance.xmlrpc.timezone}")
    private TimeZone timeZone;

    private final DynamicProperty<Integer> connectionTimeout =
            new DynamicProperty<>("ps-billing.balance.xmlrpc.connectionTimeout.sec", 20);
    private final DynamicProperty<Integer> requestTimeout =
            new DynamicProperty<>("ps-billing.balance.xmlrpc.requestTimeout.sec", 20);
    private final DynamicProperty<Integer> maxRetries =
            new DynamicProperty<>("ps-billing.balance.xmlrpc.maxRetries", 2);


    // for tests
    private Option<ProxyHost> proxy;
    private Tvm2 tvm2;
    private Function<String, Option<Integer>> dstClientIdsResolver;

    public Duration getConnectionTimeout() {
        return Duration.standardSeconds(connectionTimeout.get());
    }

    public Duration getRequestTimeout() {
        return Duration.standardSeconds(requestTimeout.get());
    }

    public Integer getMaxRetries() {
        return maxRetries.get();
    }

    public BalanceXmlRpcClientConfig(Tvm2 tvm2, Function<String, Option<Integer>> dstClientIdsResolver) {
        this(tvm2, dstClientIdsResolver, Option.empty());
    }

    public BalanceXmlRpcClientConfig(
            Tvm2 tvm2, Function<String, Option<Integer>> dstClientIdsResolver, Option<ProxyHost> proxy) {
        this.tvm2 = tvm2;
        this.dstClientIdsResolver = dstClientIdsResolver;
        this.proxy = proxy;
    }
}
