package ru.yandex.chemodan.balanceclient.exception;

import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.enums.EnumResolver;

@Getter
public class BalanceErrorCodeException extends BalanceException {
    private final ListF<String> codes;
    private final String description;

    public BalanceErrorCodeException(ListF<String> codes, String message, String description) {
        super(message);
        this.codes = codes;
        this.description = description;
    }

    public BalanceErrorCodeException(ListF<String> codes, String message, String description, Throwable cause) {
        super(message, cause);
        this.codes = codes;
        this.description = description;
    }

    public String concatenatedCodes() {
        return String.join("; ");
    }

    public enum BalanceErrorCode {
        //see https://bb.yandex-team.ru/projects/BILLING/repos/tools/browse/balance/exc
        CONTRACT_RULE_VIOLATION,
        INVALID_INN,
        INVALID_EGRPOU,
        INVALID_KLADR,
        INVALID_FIAS,
        INVALID_KBE,
        MISSING_MANDATORY_PERSON_FIELD,
        WRONG_BIK,
        WRONG_ACCOUNT,
        WRONG_EMAIL,
        WRONG_OKTMO_LENGTH,
        NO_PAYMENTS_FOR_REQUEST,
        CLIENT_NOT_FOUND;

        public static boolean isKnown(String code) {
            return R.valueOfO(code).isPresent();
        }

        public static final EnumResolver<BalanceErrorCode> R = EnumResolver.er(BalanceErrorCode.class);
    }
}
