package ru.yandex.chemodan.balanceclient.model.method;

import ru.yandex.chemodan.balanceclient.JsonUtils;

/**
 * Класс для описания методов XML-RPC API баланса, которые возвращают результат в виде объекта
 */

public class BalanceClassMethodSpec<R> extends BaseBalanceMethodSpec<R> {
    private Class<R> objClass;

    /**
     * @param handleName название метода
     * @param objClass   класс описывающий объект результата.
     */
    public BalanceClassMethodSpec(String handleName, Class<R> objClass) {
        super(handleName);
        this.objClass = objClass;
    }

    @Override
    public R convertResponse(Object response) {
        return JsonUtils.MAPPER.convertValue(response, objClass);
    }
}
