package ru.yandex.chemodan.balanceclient.model.method;

import ru.yandex.chemodan.balanceclient.JsonUtils;
import ru.yandex.chemodan.balanceclient.exception.BalanceException;
import ru.yandex.chemodan.balanceclient.model.response.BalanceExtendedStatusResponse;

/**
 * Класс для описания методов XML-RPC API баланса, которые возвращают результат в виде кортежа (0, "SUCCESS", Object)
 */

public class BalanceExtendedStatusMethodSpec<T> extends BaseBalanceMethodSpec<BalanceExtendedStatusResponse<T>> {
    private final Class<T> objClass;

    /**
     * @param handleName название метода
     * @param objClass   класс описывающий третий элемент кортежа с результатом.
     */
    public BalanceExtendedStatusMethodSpec(String handleName, Class<T> objClass) {
        super(handleName);
        this.objClass = objClass;
    }

    @Override
    public BalanceExtendedStatusResponse<T> convertResponse(Object response) {
        Object[] responseArray = castResponse(response);
        BalanceExtendedStatusResponse<T> mappedResponse =
                new BalanceExtendedStatusResponse<>((int) responseArray[0], (String) responseArray[1]);
        if (mappedResponse.getStatus() != 0) {
            throw new BalanceException(
                    String.format("Error balance response status: %s, message: %s", mappedResponse.getStatus(),
                            mappedResponse.getMessage()));
        }
        mappedResponse.setData(JsonUtils.MAPPER.convertValue(responseArray[2], objClass));
        return mappedResponse;
    }
}
