package ru.yandex.chemodan.balanceclient.model.method;

import java.util.TimeZone;

import ru.yandex.chemodan.balanceclient.JsonUtils;

/**
 * Базовый класс описания метода XML-RPC API баланса.
 * <p>
 * Дает возможность получить имя метода и сконвертировать ответ метода в понятную нам структуру
 */

public abstract class BaseBalanceMethodSpec<R> {
    private final String handleName;

    public BaseBalanceMethodSpec(String handleName) {
        this.handleName = handleName;
    }

    public String getFullName() {
        return handleName;
    }

    @SuppressWarnings("unchecked")
    static <T> T castResponse(Object response) {
        return (T) response;
    }

    /**
     * Сконвертировать ответ метода, представленный клиентом как Object в объект, с которым можно работать в
     * статически-типизированном мире.
     */
    public abstract R convertResponse(Object response);

    public R convertResponse(Object response, TimeZone timeZone){
        JsonUtils.MAPPER.setTimeZone(timeZone);
        return convertResponse(response);
    }
}
