package ru.yandex.chemodan.balanceclient.model.request;

//https://wiki.yandex-team.ru/Balance/XmlRpc/#balance.findclient
public enum AgencySelectPolicy {
    ASP_ALL(1), //выбрать всех
    ASP_IS_NOT_AGENCY(2), //выбрать обычных (прямых) клиентов, но не агентства
    ASP_IS_AGENCY(3), // выбрать только агентства
    ASP_AGENCIES_W_CLIENTS(4), //выбрать агентства и их прикреплённых (непрямых) клиентов
    ASP_CLIENTS_OF_AGENCY(5), //выбрать только прикреплённых (непрямых) клиентов найденных агентств
    ASP_CLIENTS_OF_AGENCY_BY_PROPS(
            6), //CLIENT_ID интерпретируется как ID агентства, далее среди клиентов данного агентства идет поиск по остальным параметрам;
    ASP_IS_SUBCLIENT(7), //искать любых прикреплённых (непрямых) клиентов;
    ASP_GET_EQUALS(8); //искать любых клиентов, вернуть их вместе с эквивалентными.

    private Integer policy;

    AgencySelectPolicy(Integer policy) {
        this.policy = policy;
    }

    public Integer getPolicyIntegerValue() {
        return policy;
    }
}
