package ru.yandex.chemodan.balanceclient.model.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Запрос для проверки статусы привязки карты
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.checkbinding
 */
public class CheckBindingRequest extends BalanceRpcRequestParam {

    @JsonIgnore
    private Long operatorUid;

    @JsonProperty("ServiceID")
    private Integer serviceId;

    @JsonProperty("PurchaseToken")
    private String purchaseToken;

    public CheckBindingRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public CheckBindingRequest withServiceId(Integer serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public CheckBindingRequest withPurchaseToken(String purchaseToken) {
        this.purchaseToken = purchaseToken;
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid.toString(), objectToMap(this)};
    }
}
